/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.ldtteam.structurize.management.StructureName;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.util.AdvancementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuilding
extends AbstractWorkOrder {
    private static final String TAG_CUSTOM_NAME = "customName";
    private static final String TAG_CUSTOM_PARENT_NAME = "customParentName";
    private static final String TAG_PARENT_TRANSLATION_KEY = "parentTranslationKey";
    private static final double MAX_DISTANCE_SQ = 10000.0;
    private String customName;
    private String customParentName;
    private String parentTranslationKey;

    public static WorkOrderBuilding create(@NotNull WorkOrderType type, @NotNull IBuilding building) {
        int targetLevel = building.getBuildingLevel();
        switch (type) {
            case BUILD: {
                targetLevel = 1;
                break;
            }
            case UPGRADE: {
                ++targetLevel;
                break;
            }
            case REMOVE: {
                targetLevel = 0;
            }
        }
        int targetSchematicLevel = type == WorkOrderType.REMOVE ? building.getBuildingLevel() : targetLevel;
        BlockEntity buildingTE = building.getColony().getWorld().m_7702_(building.getID());
        String schematicName = buildingTE instanceof AbstractTileEntityColonyBuilding ? (!((AbstractTileEntityColonyBuilding)buildingTE).getSchematicName().isEmpty() ? ((AbstractTileEntityColonyBuilding)buildingTE).getSchematicName().replaceAll("\\d$", "") + targetSchematicLevel : building.getSchematicName() + targetSchematicLevel) : building.getSchematicName() + targetSchematicLevel;
        String structureName = new StructureName("schematics", building.getStyle(), schematicName).toString();
        WorkOrderBuilding wo = new WorkOrderBuilding(structureName, building.getBuildingType().getTranslationKey(), type, building.getID(), building.getRotation(), building.getTileEntity() == null ? building.isMirrored() : building.getTileEntity().isMirrored(), building.getBuildingLevel(), targetLevel);
        wo.setCustomName(building);
        return wo;
    }

    public WorkOrderBuilding() {
    }

    private WorkOrderBuilding(String structureName, String workOrderName, WorkOrderType workOrderType, BlockPos location, int rotation, boolean isMirrored, int currentLevel, int targetLevel) {
        super(structureName, workOrderName, workOrderType, location, rotation, isMirrored, currentLevel, targetLevel);
    }

    public String getCustomName() {
        return this.customName;
    }

    public String getCustomParentName() {
        return this.customParentName;
    }

    public String getParentTranslationKey() {
        return this.parentTranslationKey;
    }

    public void setCustomName(@NotNull IBuilding building) {
        IBuilding parentBuilding;
        this.customName = building.getCustomName();
        this.customParentName = "";
        this.parentTranslationKey = "";
        if (building.hasParent() && (parentBuilding = building.getColony().getBuildingManager().getBuilding(building.getParent())) != null) {
            this.customParentName = parentBuilding.getCustomName();
            this.parentTranslationKey = parentBuilding.getBuildingType().getTranslationKey();
        }
    }

    @Override
    public Component getDisplayName() {
        TranslatableComponent buildingComponent;
        String customParentName = this.getCustomParentName();
        String customName = this.getCustomName();
        Object object = buildingComponent = customName.isEmpty() ? new TranslatableComponent(this.getWorkOrderName()) : new TextComponent(customName);
        if (this.parentTranslationKey.isEmpty()) {
            return buildingComponent;
        }
        TranslatableComponent parentComponent = customParentName.isEmpty() ? new TranslatableComponent(this.parentTranslationKey) : new TextComponent(customParentName);
        return new TranslatableComponent("%s / %s", new Object[]{parentComponent, buildingComponent});
    }

    @Override
    public boolean canBeMadeBy(IJob<?> job) {
        return job instanceof JobBuilder;
    }

    @Override
    public boolean canBuild(@NotNull ICitizenData citizen) {
        IBuilding building = citizen.getWorkBuilding();
        return this.canBuildIgnoringDistance(building.getPosition(), building.getBuildingLevel()) && citizen.getWorkBuilding().getPosition().m_123331_((Vec3i)this.getLocation()) <= 10000.0;
    }

    private boolean canBuildIgnoringDistance(@NotNull BlockPos builderLocation, int builderLevel) {
        return builderLevel >= this.getTargetLevel() || builderLevel == 5 || builderLocation.equals((Object)this.getLocation());
    }

    @Override
    public boolean tooFarFromAnyBuilder(IColony colony, int level) {
        return colony.getBuildingManager().getBuildings().values().stream().noneMatch(building -> building instanceof BuildingBuilder && !building.getAllAssignedCitizen().isEmpty() && building.getPosition().m_123331_((Vec3i)this.getLocation()) <= 10000.0);
    }

    @Override
    public boolean isValid(@NotNull IColony colony) {
        return super.isValid(colony) && colony.getBuildingManager().getBuilding(this.getLocation()) != null;
    }

    @Override
    public void read(@NotNull CompoundTag compound, IWorkManager manager) {
        super.read(compound, manager);
        this.customName = compound.m_128461_(TAG_CUSTOM_NAME);
        this.customParentName = compound.m_128461_(TAG_CUSTOM_PARENT_NAME);
        this.parentTranslationKey = compound.m_128461_(TAG_PARENT_TRANSLATION_KEY);
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        super.write(compound);
        compound.m_128359_(TAG_CUSTOM_NAME, this.customName);
        compound.m_128359_(TAG_CUSTOM_PARENT_NAME, this.customParentName);
        compound.m_128359_(TAG_PARENT_TRANSLATION_KEY, this.parentTranslationKey);
    }

    @Override
    public void serializeViewNetworkData(@NotNull FriendlyByteBuf buf) {
        super.serializeViewNetworkData(buf);
        buf.m_130070_(this.customName);
        buf.m_130070_(this.customParentName);
        buf.m_130070_(this.parentTranslationKey);
    }

    @Override
    public void onCompleted(IColony colony, ICitizenData citizen) {
        super.onCompleted(colony, citizen);
        StructureName structureName = new StructureName(this.getStructureName());
        if (this.getWorkOrderType() != WorkOrderType.REMOVE) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(colony, player -> AdvancementTriggers.COMPLETE_BUILD_REQUEST.trigger((ServerPlayer)player, structureName, this.getTargetLevel()));
        }
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
        IBuilding building;
        if (!readingFromNbt && colony != null && colony.getWorld() != null && (building = colony.getBuildingManager().getBuilding(this.getLocation())) != null) {
            ConstructionTapeHelper.placeConstructionTape(building.getCorners(), colony.getWorld());
        }
    }

    @Override
    public void onRemoved(IColony colony) {
        IBuilding building = colony.getBuildingManager().getBuilding(this.getLocation());
        if (building != null) {
            building.markDirty();
            ConstructionTapeHelper.removeConstructionTape(building.getCorners(), colony.getWorld());
        }
    }
}

